package gov.cms.grouper.snf.component.v100;

import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.spy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.util.ClaimInfo;


public class TestUtil {


  public static ClaimInfo of(Integer functionScore) {
    return of(false, Arrays.asList(), functionScore);
  }

  public static ClaimInfo of(List<Assessment> assessments) {
    return of(false, assessments, null);
  }

  public static ClaimInfo of(List<Assessment> assessments, Integer functionScore) {
    return of(false, assessments, functionScore);
  }

  public static ClaimInfo of(boolean ipa, List<Assessment> assessments, Integer functionScore) {
    final ClaimInfo r = new ClaimInfo(100, ipa, assessments);
    ClaimInfo spy = spy(r);

    if (functionScore != null) {
      doReturn(functionScore).when(spy).getFunctionScore();
    }

    return spy;
  }


  public static List<Assessment> getAll(int value) {
    Set<Rai300> set = SnfUtils.toSet(true, Rai300.values());
    return TestUtil.getAll(set, value);
  }

  public static List<Assessment> getAll(Set<Rai300> set, int value) {
    List<Assessment> ast = new ArrayList<>(set.size());
    for (Rai300 r : set) {
      ast.add(new Assessment(r.name(), r.name(), value));
    }
    return ast;
  }

}
